VERSION 5.00
Begin VB.Form DC_PriceListLineSurchargeDetail 
   Caption         =   "#Surcharge link detail"
   ClientHeight    =   2985
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   2985
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txt_DCS_Price 
      Height          =   330
      Left            =   1560
      MaxLength       =   10
      TabIndex        =   7
      Tag             =   "DCS_Price"
      Top             =   1110
      Width           =   1125
   End
   Begin VB.TextBox txt_DCS_Formula 
      Height          =   330
      Left            =   1560
      MaxLength       =   255
      TabIndex        =   6
      Tag             =   "DCS_Formula"
      Top             =   1590
      Width           =   3045
   End
   Begin VB.TextBox txt_DCS_Code 
      Height          =   330
      Left            =   1560
      Locked          =   -1  'True
      MaxLength       =   4
      TabIndex        =   5
      Tag             =   "DCS_Code"
      Top             =   90
      Width           =   1125
   End
   Begin VB.TextBox txt_DCS_Desc 
      Height          =   330
      Left            =   1560
      Locked          =   -1  'True
      MaxLength       =   50
      TabIndex        =   4
      Tag             =   "DCS_Desc"
      Top             =   555
      Width           =   3075
   End
   Begin VB.CommandButton OKButton 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   3420
      TabIndex        =   3
      Top             =   2550
      Width           =   1215
   End
   Begin VB.CommandButton CancelButton 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   1995
      TabIndex        =   2
      Top             =   2550
      Width           =   1215
   End
   Begin VB.CheckBox chk_DCS_Default 
      Height          =   315
      Left            =   1560
      TabIndex        =   1
      Tag             =   "DCS_Default"
      Top             =   2055
      Width           =   285
   End
   Begin VB.CheckBox chk_DCS_IsUsed 
      Height          =   315
      Left            =   4320
      TabIndex        =   0
      Tag             =   "DCS_IsUsed"
      Top             =   2055
      Width           =   285
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#Formula"
      Height          =   300
      Index           =   1
      Left            =   60
      TabIndex        =   14
      Tag             =   "lbl_DCS_Formula"
      Top             =   1620
      Width           =   1365
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#ID"
      Height          =   300
      Index           =   2
      Left            =   60
      TabIndex        =   13
      Tag             =   "lbl_DCS_Price"
      Top             =   120
      Width           =   1365
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#Surcharge"
      Height          =   300
      Index           =   3
      Left            =   60
      TabIndex        =   12
      Tag             =   "lbl_DCS_Desc"
      Top             =   585
      Width           =   1365
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#Price"
      Height          =   300
      Index           =   0
      Left            =   60
      TabIndex        =   11
      Tag             =   "lbl_DCS_Price"
      Top             =   1140
      Width           =   1365
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#EUR"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   4
      Left            =   2820
      TabIndex        =   10
      Tag             =   "lbl_DCS_Price"
      Top             =   1155
      Width           =   1785
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#Is default"
      Height          =   300
      Index           =   5
      Left            =   60
      TabIndex        =   9
      Tag             =   "lbl_DCS_Default"
      Top             =   2100
      Width           =   1365
   End
   Begin VB.Label lbl_labels 
      Alignment       =   1  'Right Justify
      Caption         =   "#Is ussed"
      Height          =   300
      Index           =   6
      Left            =   2550
      TabIndex        =   8
      Tag             =   "lbl_DCS_LinkedTrans"
      Top             =   2100
      Width           =   1665
   End
End
Attribute VB_Name = "DC_PriceListLineSurchargeDetail"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "DC_PriceListLineSurcharge"

Private mb_Initialized As Boolean

Public Result As Boolean
Public DCS_Code As String
Public DCS_Desc As String
Public DCS_Price As Double
Public DCS_Formula As String
Public DCS_Default As Boolean
Private DCS_LinkedTrans As Long
Public CURR_Code As String

Private ml_U_Code As Long
Private ms_LoginName As String
Private ms_Language_Code As String

Private mo_Db As ARMSYSCOMLib.ArmDb
Private ms_reconnectServer As String
Private ms_reconnectDB As String
Private ms_reconnectUser As String
Private ms_reconnectPassword As String
Private ms_reconnectApp As String


Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo errhandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate Me.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        Me.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
    
errhandler:
'    Call errorHandler("LockScreen")
End Sub

Public Sub SetReconnectParams(ByVal as_Server As String, ByVal as_Db As String, ByVal as_User As String, ByVal as_Password As String, ByVal as_App As String)
On Error GoTo errhandler
    ms_reconnectServer = as_Server
    ms_reconnectDB = as_Db
    ms_reconnectUser = as_User
    ms_reconnectPassword = as_Password
    ms_reconnectApp = as_App
    Exit Sub
errhandler:
    Call ErrorMessage("SetReconnectParams")
End Sub

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Property Let Language_Code(AString As String)
On Error GoTo errhandler

  ms_Language_Code = AString
  Exit Property
errhandler:
  Call ErrorMessage("Language_Code.Let")
End Property

Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo errhandler

  ml_U_Code = al_U_Code
  Exit Property
errhandler:
  Call ErrorMessage("U_Code.Let")
End Property

Public Property Let LoginName(ByVal as_loginName As String)
On Error GoTo errhandler
    
    ms_LoginName = as_loginName
    Exit Property
errhandler:
    Call ErrorMessage(Me.Name & ".LoginName(Let)")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo errhandler
  
  Set mo_Db = lo_Db
  Exit Property
errhandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Sub Load_A_COM()
On Error GoTo errhandler

    If mb_Initialized Then Exit Sub
    
    mb_Initialized = True
    
    Result = False
    DCS_Code = ""
    DCS_Desc = ""
    DCS_Price = 0
    DCS_Formula = ""
    CURR_Code = ""
    
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        End Select
    Next
    
    Call LoadLabels(Me.Controls, SCREEN_NAME, ms_Language_Code)
    Call ChangeCharset(Me.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))

    Exit Sub
    
errhandler:
    Call ErrorHandler("Load_A_COM")
End Sub

Public Property Let Title(ByVal as_caption As String)
    Me.Caption = as_caption
End Property

Private Sub CancelButton_Click()
    Result = False
    Call txt_DCS_Price.SetFocus
    Me.Hide
End Sub

Private Sub OKButton_Click()
    If Not txt_DCS_Price.Locked Then
        If Item_Check Then
            Call Item_Save
            Call txt_DCS_Price.SetFocus
            Me.Hide
        End If
    Else
        Call txt_DCS_Price.SetFocus
        Me.Hide
    End If
End Sub

Private Sub Item_Save()
    Result = True
    
    DCS_Price = Trim(txt_DCS_Price.Text)
    DCS_Formula = Trim(txt_DCS_Formula.Text)
    DCS_Default = (chk_DCS_Default.Value = vbChecked)

End Sub

Private Function Item_Check() As Boolean
    Item_Check = False
    
    If Not isNumeric(txt_DCS_Price.Text) Then
        MsgBox ("Invalid value in Price.")
        txt_DCS_Price.SelStart = 0
        txt_DCS_Price.SelLength = Len(txt_DCS_Price.Text)
        Call txt_DCS_Price.SetFocus
        Exit Function
    End If
    
    Item_Check = True
End Function

Private Sub Item_Load()
On Error GoTo errhandler
    
    txt_DCS_Code.Text = DCS_Code
    txt_DCS_Desc.Text = DCS_Desc
    txt_DCS_Price = DCS_Price
    lbl_labels(4).Caption = CURR_Code
    txt_DCS_Formula = DCS_Formula
    chk_DCS_Default.Value = IIf(DCS_Default, vbChecked, vbUnchecked)
    chk_DCS_IsUsed.Value = IIf(DCS_LinkedTrans = 0, vbUnchecked, IIf(DCS_LinkedTrans = -1, vbGrayed, vbChecked))
    
    Exit Sub
errhandler:
    Call ErrorHandler("Item_Load()")
End Sub

Private Sub Item_Clear()
On Error GoTo errhandler
    
    txt_DCS_Code.Text = ""
    txt_DCS_Desc.Text = ""
    txt_DCS_Price = ""
    txt_DCS_Formula = ""
    chk_DCS_Default.Value = vbUnchecked
    
    Exit Sub
errhandler:
    Call ErrorHandler("Item_Clear()")
End Sub

Private Sub Item_InitUpdate()
On Error GoTo errhandler
    Call Item_Clear
    
    Call Item_Load
    
    ' updateUI
    Call EnableControl(txt_DCS_Code, False)
    Call EnableControl(txt_DCS_Desc, False)
    Call EnableControl(chk_DCS_IsUsed, False)
    Call EnableControl(txt_DCS_Price, True)
    Call EnableControl(txt_DCS_Formula, True)
    Call EnableControl(chk_DCS_Default, True)
    
    txt_DCS_Price.SelStart = 0
    txt_DCS_Price.SelLength = Len(txt_DCS_Price.Text)
    
    
    Exit Sub
errhandler:
    Call ErrorMessage("Item_InitUpdate")
End Sub

Private Sub Item_InitView()
On Error GoTo errhandler
    Call Item_Clear
    
    Call Item_Load
    
    ' updateUI
    Call EnableControl(txt_DCS_Code, False)
    Call EnableControl(txt_DCS_Desc, False)
    Call EnableControl(chk_DCS_IsUsed, False)
    Call EnableControl(txt_DCS_Price, False)
    Call EnableControl(txt_DCS_Formula, False)
    Call EnableControl(chk_DCS_Default, False)
    
    Exit Sub
errhandler:
    Call ErrorMessage("Item_InitUpdate")
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
'    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, Me.Name & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo errhandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
errhandler:
    Call ErrorHandler(Me.Name & ".GetDbError()")
End Function

' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo errhandler

    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    
    Dim ll_ScreenLabels As Long

    ll_ScreenLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (ll_ScreenLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU", "CHECKBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is Frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                      Call lControl.LoadConstants(ptStatic, mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT"), ctColumns)
                        End If
                    If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag & "_Title", , 1) >= 0 Then
                      lControl.Title = mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT")
                    End If
                Case "TABSTRIP"
                    If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    Exit Sub

errhandler:
    Call ErrorHandler(Me.Name & ".LoadLabels")
End Sub

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo errhandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub

errhandler:
    Call ErrorHandler(Me.Name & ".ChangeCharset")
End Sub



Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
On Error GoTo errhandler
    Dim lc_Data As Long
tryAgain:
    lc_Data = ao_Db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        
        Dim ls_ErrMsg As String
        ls_ErrMsg = "SQL Error: " & GetDbError(ao_Db)
        
        If ReconnectSafe() Then
            GoTo tryAgain
        End If
        
        Call Err.Raise(1, "ao_Db.OpenSQL - " & "SQL : " & as_Request, ls_ErrMsg)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(2, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
errhandler:
    Call ErrorHandler(Me.Name & ".OpenSQLSafe")
End Function

Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
On Error GoTo errhandler

tryAgain:
    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        If GetArrayValue(ao_Db.SQLErrorCodes, 0) = 547 Then
            Err.Raise 3, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        End If
        
        Dim ls_ErrMsg As String
        ls_ErrMsg = Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        
        If ReconnectSafe() Then
            GoTo tryAgain
        End If
        
        Err.Raise 1, "SQL : " & as_Request, ls_ErrMsg
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise 4, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise 5, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If
    
    Exit Sub

errhandler:
    Call ErrorHandler(Me.Name & ".ExecuteSQLSafe")
End Sub

Private Function ReconnectSafe() As Boolean
On Error GoTo errhandler

    ReconnectSafe = False
    
    Dim ll_Counter As Long
    ll_Counter = 3              ' try 3 times to connect
    
    If IsLostConnection(mo_Db) Then
    
        Call mo_Db.Disconnect
        
        Do While ll_Counter > 0
        
            If mo_Db.Connect(ms_reconnectServer, ms_reconnectDB, ms_reconnectUser, ms_reconnectPassword, ms_reconnectApp) Then
                ReconnectSafe = True
                Exit Do
            End If
            
            ll_Counter = ll_Counter - 1
        Loop
        
    End If
    
    Exit Function
errhandler:
     Call ErrorHandler("ReconnectSafe()")
End Function

Private Function IsLostConnection(ByRef ao_Armdb As ArmDb) As Boolean
On Error GoTo errhandler
    
    IsLostConnection = Not ao_Armdb.IsConnected
    
    If IsArray(ao_Armdb.SQLErrorCodes) Then
        Dim lv_ErrCode As Variant
        Dim ll_Index As Long
        
        lv_ErrCode = ao_Armdb.SQLErrorCodes
        
        For ll_Index = LBound(lv_ErrCode) To UBound(lv_ErrCode)
            If lv_ErrCode(ll_Index) = 11 Then       '[DBNETLIB][ConnectionWrite (send()).]General network error. Check your network documentation.
                IsLostConnection = True
                Exit For
            End If
        Next

    End If
    
    Exit Function
errhandler:
     Call ErrorHandler("IsLostConnection()")
End Function

Private Function GetArrayValue(ByRef ao_variantArray As Variant, ByVal al_Index As Long) As Variant
    If IsArray(ao_variantArray) Then
        If UBound(ao_variantArray) <= al_Index Then
            GetArrayValue = ao_variantArray(al_Index)
        Else
            GetArrayValue = 0
        End If
    Else
        GetArrayValue = 0
    End If
End Function

Public Sub Run(ByVal as_DCS_Code As String, ByVal as_DCS_Desc As String, ByVal ad_DCS_Price As Double, ByVal as_DCS_Formula As String, ByVal ab_DCS_Default As Boolean, ByVal al_DCS_LinkedTrans As Long, ByVal as_CURR_Code As String, ByVal as_action As String)
On Error GoTo errhandler

    DCS_Code = as_DCS_Code
    DCS_Desc = as_DCS_Desc
    DCS_Price = ad_DCS_Price
    DCS_Formula = as_DCS_Formula
    DCS_Default = ab_DCS_Default
    DCS_LinkedTrans = al_DCS_LinkedTrans
    CURR_Code = as_CURR_Code
    Result = False
    
    Select Case as_action
    Case "U"
        Call Item_InitUpdate
    Case "V"
        Call Item_InitView
    End Select
    
    Dim ll_oldCursor As Long
    ll_oldCursor = Screen.MousePointer
    Screen.MousePointer = vbDefault
    Call Me.show(vbModal)
    Screen.MousePointer = ll_oldCursor

    Exit Sub
errhandler:
    Call ErrorHandler(Name & ".Run")
End Sub

Private Sub EnableControl(ByVal ao_Control As Control, ByVal ab_Enabled As Boolean)
On Error GoTo errhandler

    Select Case UCase(TypeName(ao_Control))
        Case "FRAME", "LABEL", "MSFLEXGRID", "SHAPE", "ARMGRID", "ARMCHECKVIEW", "TABSTRIP"
            ao_Control.Enabled = ab_Enabled
            ' Do nothing !
        Case "LISTVIEW"
            ' Do nothing !
        Case "TEXTBOX"
            ao_Control.Locked = Not ab_Enabled
            ao_Control.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
            ao_Control.TabStop = ab_Enabled
        Case "OPTIONBUTTON"
            ao_Control.Enabled = ab_Enabled
        Case "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "CHECKBOX", "COMMANDBUTTON", "TOOLBARCONTROL"
            ao_Control.Enabled = ab_Enabled
            ao_Control.TabStop = ab_Enabled
        Case Else
          Debug.Print ao_Control.Name
    End Select
  Exit Sub
errhandler:
  Call ErrorHandler("EnableControl")
End Sub


